/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.datasource;

import com.jk.db.datasource.JKDataSource;
import com.jk.exceptions.JKDataAccessException;
import java.sql.Connection;
import java.sql.SQLException;

public class JKSession {
    private Connection connection;
    private boolean commit;
    private boolean rollBackOnly;
    boolean closed;
    private JKSession parentSession;
    private JKDataSource connectionManager;

    private JKSession(Connection connection) throws JKDataAccessException {
        this.connection = connection;
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new JKDataAccessException(e);
        }
    }

    public JKSession(JKDataSource connectionManager) throws JKDataAccessException {
        this(connectionManager.getConnection());
        this.connectionManager = connectionManager;
    }

    public JKSession(JKSession parentSession) {
        this.parentSession = parentSession;
    }

    public void close() throws JKDataAccessException {
        if (this.parentSession != null) {
            return;
        }
        try {
            if (this.connection == null || this.connection.isClosed()) {
                throw new IllegalStateException("Invalid call to Session.close on closed session");
            }
            if (this.isCommit() && !this.isRollbackOnly()) {
                this.connection.commit();
            } else {
                this.connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new JKDataAccessException(e);
        }
        finally {
            this.connectionManager.close(this.connection);
            this.setClosed(true);
        }
    }

    public void close(boolean commit) throws JKDataAccessException {
        this.commit(commit);
        this.close();
    }

    protected void commit(boolean commit) {
        if (this.parentSession != null) {
            this.parentSession.commit(commit);
        } else if (!commit) {
            this.rollBackOnly = true;
        } else {
            this.commit = true;
        }
    }

    public Connection getConnection() {
        return this.parentSession != null ? this.parentSession.getConnection() : this.connection;
    }

    public JKDataSource getConnectionManager() {
        JKDataSource manager;
        JKDataSource jKDataSource = manager = this.parentSession != null ? this.parentSession.getConnectionManager() : this.connectionManager;
        if (manager == null) {
            throw new IllegalStateException("Connectino manager connot be null");
        }
        return manager;
    }

    public JKSession getParentSession() {
        return this.parentSession;
    }

    public boolean isClosed() {
        return this.parentSession != null ? this.parentSession.isClosed() : this.closed;
    }

    public boolean isCommit() {
        return this.parentSession != null ? this.parentSession.isCommit() : this.commit;
    }

    private boolean isRollbackOnly() {
        return this.rollBackOnly;
    }

    private void setClosed(boolean closed) {
        this.closed = closed;
    }
}

