/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.datasource;

import com.jk.db.datasource.JKDefaultDataSource;
import com.jk.exceptions.JKDataAccessException;
import com.jk.util.JKCollectionUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp2.BasicDataSource;

public class JKPoolingDataSource
extends JKDefaultDataSource {
    private BasicDataSource datasource;

    public JKPoolingDataSource(Properties prop) {
        super(prop);
    }

    @Override
    protected Connection connect() throws SQLException {
        return this.datasource.getConnection();
    }

    private int getInitialPoolSize() {
        return Integer.parseInt(this.getProperty("db-initial-size", "2"));
    }

    private int getMaxPoolSize() {
        return Integer.parseInt(this.getProperty("db-max-total", "10"));
    }

    @Override
    public Connection getQueryConnection() throws JKDataAccessException {
        Connection queryConnection = super.getQueryConnection();
        try {
            this.testConnection(queryConnection);
        }
        catch (SQLException e) {
            queryConnection = null;
            throw new JKDataAccessException("DATABASE_DOWN_ERROR", e);
        }
        return queryConnection;
    }

    @Override
    protected void init() {
        super.init();
        this.logger.debug("Constructing database pool with settings :", JKCollectionUtil.toString(this.getProperties()));
        this.datasource = new BasicDataSource();
        this.datasource.setDriverClassName(super.getDriverName());
        this.datasource.setUrl(this.getDatabaseUrl());
        this.datasource.setUsername(this.getUsername());
        this.datasource.setPassword(this.getPassword());
        this.datasource.setInitialSize(this.getInitialPoolSize());
        this.datasource.setMaxTotal(this.getMaxPoolSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection(Connection queryConnection) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = queryConnection.prepareStatement(this.getTestQuery());
            ps.executeQuery();
        }
        finally {
            this.close(ps);
        }
    }
}

