/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.datasource;

import com.jk.annotations.AnnotationDetector;
import com.jk.cache.JKCacheFactory;
import com.jk.cache.JKCacheManager;
import com.jk.db.dataaccess.orm.hibernate.JKEntityManagerFactory;
import com.jk.db.dataaccess.orm.hibernate.JKPersistenceUnitInfoImpl;
import com.jk.db.datasource.JKAbstractDataSource;
import com.jk.util.JK;
import com.jk.util.JKConversionUtil;
import java.util.List;
import java.util.Properties;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;

public class JKDefaultDataSource
extends JKAbstractDataSource {
    private final Properties config;
    private String driverName;
    private String dbUrl;
    private String userName;
    private String password;
    private String entitiesPackages;

    public JKDefaultDataSource(Properties config) {
        this.config = config;
        this.init();
    }

    @Override
    public String getDatabaseUrl() {
        return this.dbUrl;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Properties getProperties() {
        return this.config;
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.config.getProperty(name, defaultValue);
    }

    @Override
    public String getTestQuery() {
        return this.config.getProperty("DB_TEST_QUERY", "SELECT 1");
    }

    @Override
    public String getUsername() {
        return this.userName;
    }

    protected void init() {
        this.logger.debug("init");
        this.driverName = this.config.getProperty("db-driver-name", "com.mysql.jdbc.Driver");
        this.dbUrl = this.config.getProperty("db-url", "jdbc:mysql://localhost:3306/app");
        this.userName = this.config.getProperty("db-user", "root");
        this.password = this.config.getProperty("db-password", "123456");
        this.entitiesPackages = this.config.getProperty("db-entities-packages", "com.app");
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        this.logger.debug("getEntityManagerFactory");
        return this.getEntityManagerFactory("JK-DB");
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory(String name) {
        this.logger.debug("getEntityManagerFactory() ", name);
        EntityManagerFactory emf = this.getCache().get(name, EntityManagerFactory.class);
        if (emf == null) {
            this.logger.debug("EMF not loaded, loading now...");
            Properties prop = new Properties();
            prop.setProperty("javax.persistence.jdbc.driver", this.getDriverName());
            prop.setProperty("javax.persistence.jdbc.password", this.getPassword());
            prop.setProperty("javax.persistence.jdbc.url", this.getDatabaseUrl());
            prop.setProperty("javax.persistence.jdbc.user", this.getUsername());
            PersistenceUnitInfo persisitnceUnitInfo = this.getPersisitnceUnitInfo(name, prop, this.getEntitiesPackages());
            emf = JKEntityManagerFactory.createEntityManagerFactory(persisitnceUnitInfo);
            this.logger.debug("add to emf cache ");
            this.getCache().cache(name, emf, EntityManagerFactory.class);
        }
        return emf;
    }

    protected JKCacheManager getCache() {
        return JKCacheFactory.getCacheManager();
    }

    @Override
    public PersistenceUnitInfo getPersisitnceUnitInfo(String persisitnceUnitName, Properties prop, String entitiesPackages) {
        this.logger.debug("getPersisitnceUnitInfo: ", persisitnceUnitName, " Prop: ", prop, " Entities packages : ", entitiesPackages);
        PersistenceUnitInfo info = this.getCache().get(persisitnceUnitName, PersistenceUnitInfo.class);
        if (info == null) {
            List<String> entityClassNames = AnnotationDetector.scanAsList(Entity.class, entitiesPackages.split(","));
            this.logger.debug("Entities : ", entityClassNames);
            info = new JKPersistenceUnitInfoImpl(persisitnceUnitName, entityClassNames, prop);
            this.getCache().cache(persisitnceUnitName, info, PersistenceUnitInfo.class);
        }
        return info;
    }

    @Override
    public EntityManager createEntityManager(String emfName) {
        return this.getEntityManagerFactory(emfName).createEntityManager();
    }

    @Override
    public EntityManager createEntityManager() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        return em;
    }

    @Override
    public void close(EntityManager em, boolean commit) {
        if (em != null) {
            if (commit && !em.getTransaction().getRollbackOnly()) {
                em.getTransaction().commit();
            } else {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    @Override
    public String getEntitiesPackages() {
        return this.entitiesPackages;
    }

    @Override
    public String getDatabaseName() {
        try {
            return this.getQueryConnection().getCatalog();
        }
        catch (Exception e) {
            JK.throww(e);
            return null;
        }
    }

    @Override
    public int getQueryLimit() {
        return JKConversionUtil.toInteger(this.config.getProperty("db-rows-limit", "100"));
    }
}

