/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.datasource;

import com.jk.context.JKContextFactory;
import com.jk.db.dataaccess.JKDefaultDataAccess;
import com.jk.db.dataaccess.mysql.MysqlAbstractDao;
import com.jk.db.dataaccess.oracle.OracleAbstractDao;
import com.jk.db.dataaccess.orm.JKDefaultOrmDataAccess;
import com.jk.db.dataaccess.orm.JKOrmDataAccess;
import com.jk.db.dataaccess.plain.JKPlainDataAccess;
import com.jk.db.datasource.JKDataSource;
import com.jk.db.datasource.JKPoolingDataSource;
import com.jk.exceptions.JKException;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.resources.JKResourceLoader;
import com.jk.resources.JKResourceLoaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class JKDataSourceFactory {
    static JKLogger logger = JKLoggerFactory.getLogger(JKDataSourceFactory.class);
    private static JKDataSource defaultResourceManager;

    public static JKPoolingDataSource createInstance(Properties prop) {
        return new JKPoolingDataSource(prop);
    }

    public static JKPoolingDataSource createInstance(String driver, String url, String userName, String password) {
        Properties prop = new Properties();
        prop.setProperty("db-driver-name", driver);
        prop.setProperty("db-url", url);
        prop.setProperty("db-user", userName);
        prop.setProperty("db-password", password);
        return JKDataSourceFactory.createInstance(prop);
    }

    protected static String getConfigFileName() {
        return System.getProperty("jk.db.config.file", "jk-db.properties");
    }

    public static JKDataSource getDefaultDataSource() {
        try {
            logger.debug("get default datasource");
            if (defaultResourceManager == null) {
                logger.debug("trying to load config file");
                JKDataSourceFactory.tryLoadConfig();
                if (defaultResourceManager == null) {
                    logger.debug("no configuration file is provided , defaults will be used");
                    defaultResourceManager = JKDataSourceFactory.createInstance(new Properties());
                }
            }
            return defaultResourceManager;
        }
        catch (IOException e) {
            throw new JKException(e);
        }
    }

    public static void setDefaultDataSource(JKDataSource impl) {
        defaultResourceManager = impl;
    }

    protected static void tryLoadConfig() throws IOException {
        String configFileName = JKDataSourceFactory.getConfigFileName();
        logger.debug("configFileName :", configFileName);
        String configPath = JKContextFactory.getCurrentContext().getConfigPath();
        logger.debug("Config path: ", configPath);
        JKResourceLoader resourceLoader = JKResourceLoaderFactory.getResourceLoader();
        configFileName = configPath.concat(configFileName);
        logger.debug("Full-config filename: ", configFileName);
        InputStream in = resourceLoader.getResourceAsStream(configFileName);
        if (in != null) {
            logger.debug("Loading exists file :".concat(configFileName));
            Properties prop = new Properties();
            prop.load(in);
            logger.debug("constructing datasource");
            defaultResourceManager = JKDataSourceFactory.createInstance(prop);
        }
    }

    public static JKPlainDataAccess getPlainDataAccess() {
        String url = JKDataSourceFactory.getDefaultDataSource().getDatabaseUrl().toLowerCase();
        if (url.contains("oracle")) {
            return new OracleAbstractDao();
        }
        if (url.contains("mysql")) {
            return new MysqlAbstractDao();
        }
        return new JKDefaultDataAccess();
    }

    public static JKOrmDataAccess getOrmDataAccess() {
        return new JKDefaultOrmDataAccess();
    }
}

