/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.datasource;

import com.jk.db.dataaccess.plain.JKAbstractPlainDataAccess;
import com.jk.db.datasource.JKDataSource;
import com.jk.db.datasource.JKDatabaseType;
import com.jk.db.datasource.JKSession;
import com.jk.exceptions.JKDataAccessException;
import com.jk.exceptions.JKException;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class JKAbstractDataSource
implements JKDataSource {
    protected static int connectionsCount;
    protected JKLogger logger = JKLoggerFactory.getLogger(this.getClass());
    private JKSession parentSession;
    private Connection queryConnection;
    private boolean driverClassLoaded;

    @Override
    public void close(Connection con) {
        try {
            if (con == null || con.isClosed()) {
                return;
            }
            if (con == this.queryConnection) {
                this.logger.debug("connection is not closed because it is query connection");
            } else {
                this.logger.debug("closing connection : Current connection " + --connectionsCount);
                con.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close(Connection connection, boolean commit) {
        try {
            if (commit) {
                this.logger.debug("commit transaction");
                connection.commit();
            } else {
                this.logger.debug("rollback transaction");
                connection.rollback();
            }
            this.close(connection);
        }
        catch (SQLException e) {
            throw new JKDataAccessException(e);
        }
    }

    @Override
    public void close(ResultSet rs) {
        this.logger.debug("close rs");
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close(Statement stmt) {
        this.logger.debug(stmt);
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Connection connect() throws SQLException {
        this.logger.debug("connect");
        return DriverManager.getConnection(this.getDatabaseUrl(), this.getUsername(), this.getPassword());
    }

    @Override
    public JKSession createSession() {
        this.logger.debug("Create database session(transaction)");
        if (this.parentSession == null || this.parentSession.isClosed()) {
            this.parentSession = new JKSession(this);
            return this.parentSession;
        }
        return new JKSession(this.parentSession);
    }

    @Override
    public Connection getConnection() {
        if (!this.driverClassLoaded) {
            this.loadDriverClass();
            this.driverClassLoaded = true;
        }
        this.logger.debug("Creating connection , current opened connections : " + ++connectionsCount);
        try {
            return this.connect();
        }
        catch (SQLException e) {
            throw new JKDataAccessException(e);
        }
    }

    @Override
    public Connection getQueryConnection() throws JKDataAccessException {
        this.logger.debug("get query connection");
        if (this.queryConnection == null) {
            this.logger.debug("queryConnection is not available , creating new one");
            this.queryConnection = this.getConnection();
        }
        return this.queryConnection;
    }

    private void loadDriverClass() {
        this.logger.debug("loadDriverClass");
        try {
            Class.forName(this.getDriverName());
        }
        catch (ClassNotFoundException e) {
            throw new JKException(e);
        }
    }

    @Override
    public JKDatabaseType getDatabaseType() {
        this.logger.debug("getDatabaseType");
        String driverName = this.getDriverName().toLowerCase();
        if (driverName.contains("oracle")) {
            return JKDatabaseType.ORACLE;
        }
        if (driverName.contains("mysql")) {
            return JKDatabaseType.MYSQL;
        }
        if (driverName.contains("microsoft")) {
            return JKDatabaseType.SQLSERVER;
        }
        return JKDatabaseType.OTHER;
    }

    @Override
    public void resetCache() {
        this.logger.debug("resetCache");
        JKAbstractPlainDataAccess.resetCache();
    }
}

