/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dataaccess.plain;

import com.jk.db.dataaccess.exception.JKRecordNotFoundException;
import com.jk.db.dataaccess.plain.JKDbIdValue;
import com.jk.db.dataaccess.plain.JKFinder;
import com.jk.db.dataaccess.plain.JKPlainDataAccess;
import com.jk.db.dataaccess.plain.JKUpdater;
import com.jk.db.datasource.JKDataSource;
import com.jk.db.datasource.JKDataSourceFactory;
import com.jk.exceptions.JKDataAccessException;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.util.JK;
import com.jk.util.JKConversionUtil;
import com.jk.util.JKIOUtil;
import com.jk.util.JKObjectUtil;
import com.sun.rowset.CachedRowSetImpl;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.CachedRowSet;

public abstract class JKAbstractPlainDataAccess
implements JKPlainDataAccess {
    private static Map<String, Hashtable<Object, Object>> objectsCache = new Hashtable<String, Hashtable<Object, Object>>();
    private static Map<String, List<? extends Object>> listsCache = new Hashtable<String, List<? extends Object>>();
    JKLogger logger = JKLoggerFactory.getLogger(this.getClass());

    protected void close(Connection connection) {
        this.logger.debug("closing connection");
        if (connection == null) {
            return;
        }
        this.getDataSource().close(connection);
    }

    protected void close(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void close(PreparedStatement ps, Connection c) {
        this.close(ps);
        this.close(c);
    }

    protected void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void close(ResultSet rs, PreparedStatement ps, Connection c) {
        this.close(rs);
        this.close(ps);
        this.close(c);
    }

    protected void close(Statement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public CachedRowSet executeQueryAsCachedRowSet(String query, Object ... params) {
        this.logger.debug(String.format("executeQueryAsCachedRowSet , Query(%s) Params(%s)", query, Arrays.toString(params)));
        PreparedStatement ps = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = this.prepareQueryStatement(con, query, params);
            rs = ps.executeQuery();
            CachedRowSetImpl impl = new CachedRowSetImpl();
            impl.populate(rs);
            CachedRowSetImpl cachedRowSetImpl = impl;
            this.close(rs);
            this.close(con);
            return cachedRowSetImpl;
        }
        catch (SQLException ex) {
            try {
                throw new JKDataAccessException(ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(con);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<JKDbIdValue> executeQueryAsIdValue(String query, Object ... params) {
        this.logger.debug(String.format("executeQueryAsIdValue , Query(%s) Params(%s)", query, Arrays.toString(params)));
        if (listsCache.get(query) != null) return listsCache.get(query);
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection(true);
            ps = this.prepareQueryStatement(con, query, params);
            rs = ps.executeQuery();
            Vector<JKDbIdValue> results = new Vector<JKDbIdValue>();
            ResultSetMetaData metaData = rs.getMetaData();
            while (rs.next()) {
                JKDbIdValue combo = new JKDbIdValue();
                combo.setId(rs.getString(1));
                if (metaData.getColumnCount() >= 2) {
                    if (rs.getString(2) == null) {
                        this.logger.debug(query.concat(" generating null values"));
                    } else {
                        combo.setValue(rs.getString(2));
                    }
                } else {
                    this.logger.debug(query.concat(" generating single column only"));
                }
                results.add(combo);
            }
            listsCache.put(query, results);
        }
        catch (JKDataAccessException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    throw new JKDataAccessException(e2);
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps, con);
                throw throwable;
            }
        }
        this.close(rs, ps, con);
        return listsCache.get(query);
    }

    @Override
    public String executeQueryAsString(String query, Object ... params) {
        return this.executeQueryAsString(query, ";", JK.NEW_LINE, params);
    }

    @Override
    public String executeQueryAsString(String query, String fieldSeparator, String recordsSepartor, Object ... params) {
        this.logger.debug(String.format("executeQueryAsString , Query(%s) Params(%s)", query, Arrays.toString(params)));
        try {
            CachedRowSet rs = this.executeQueryAsCachedRowSet(query, params);
            ResultSetMetaData meta = rs.getMetaData();
            StringBuffer buf = new StringBuffer();
            while (rs.next()) {
                if (buf.length() > 0) {
                    buf.append(recordsSepartor);
                }
                for (int i = 0; i < meta.getColumnCount(); ++i) {
                    if (i > 0) {
                        buf.append(fieldSeparator);
                    }
                    buf.append(rs.getObject(i + 1));
                }
            }
            return buf.toString();
        }
        catch (SQLException e) {
            throw new JKDataAccessException(e);
        }
    }

    @Override
    public int executeUpdate(JKUpdater updater) throws JKDataAccessException {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(updater.getQuery(), 1);
            updater.setParamters(ps);
            this.logger.debug("executeUpdater, Prepared statement: ", ps);
            int count = ps.executeUpdate();
            this.logger.debug("affected rows : ", count);
            if (count == 0) {
                throw new JKRecordNotFoundException("RECORD_NOT_FOUND");
            }
            int generatedKeys = this.getGeneratedKeys(ps);
            this.logger.debug("generatedKeys : ", generatedKeys);
            int n = generatedKeys;
            this.close(ps, connection);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new JKDataAccessException(e);
            }
            catch (Throwable throwable) {
                this.close(ps, connection);
                throw throwable;
            }
        }
    }

    @Override
    public int executeUpdate(JKUpdater updater, boolean ignoreRecordNotFoundException) {
        try {
            return this.executeUpdate(updater);
        }
        catch (JKRecordNotFoundException e) {
            if (!ignoreRecordNotFoundException) {
                throw e;
            }
            return 0;
        }
    }

    @Override
    public int execute(String query, Object ... params) throws JKDataAccessException {
        this.logger.debug(String.format("executeUpdat, Query(%s) , Params (%s)", query, Arrays.toString(params)));
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            int count;
            connection = this.getConnection();
            ps = this.prepareStatement(connection, query, params);
            int n = count = ps.executeUpdate();
            this.close(ps);
            this.close(connection);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new JKDataAccessException(e);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(connection);
                throw throwable;
            }
        }
    }

    @Override
    public Object[] executeQueryAsArray(String query, Object ... params) {
        this.logger.debug(String.format("executeQueryAsArray, Query(%s) , Params (%s)", query, Arrays.toString(params)));
        try {
            CachedRowSet rs = this.executeQueryAsCachedRowSet(query, params);
            ResultSetMetaData meta = rs.getMetaData();
            Vector<Object[]> rows = new Vector<Object[]>();
            while (rs.next()) {
                Object[] row = new Object[meta.getColumnCount()];
                for (int i = 0; i < meta.getColumnCount(); ++i) {
                    row[i] = rs.getObject(i + 1);
                }
                rows.add(row);
            }
            return rows.toArray();
        }
        catch (SQLException e) {
            throw new JKDataAccessException(e);
        }
    }

    @Override
    public List<List<Object>> executeQueryAsList(String query, Object ... params) {
        this.logger.debug(String.format("executeQueryAsList, Query(%s) , Params (%s)", query, Arrays.toString(params)));
        try {
            CachedRowSet rs = this.executeQueryAsCachedRowSet(query, params);
            ResultSetMetaData meta = rs.getMetaData();
            Vector<List<Object>> rows = new Vector<List<Object>>();
            while (rs.next()) {
                Vector<Object> row = new Vector<Object>();
                for (int i = 0; i < meta.getColumnCount(); ++i) {
                    row.add(rs.getObject(i + 1));
                }
                rows.add(row);
            }
            return rows;
        }
        catch (SQLException e) {
            throw new JKDataAccessException(e);
        }
    }

    @Override
    public Object exeuteSingleOutputQuery(String query, Object ... params) {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block5: {
            this.logger.debug(String.format("executeQueryAsSingleOutput, Query(%s) , Params (%s)", query, Arrays.toString(params)));
            con = null;
            ps = null;
            rs = null;
            con = this.getConnection(true);
            ps = this.prepareQueryStatement(con, query, params);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Object object = rs.getObject(1);
            this.close(rs, ps, con);
            return object;
        }
        try {
            try {
                throw new JKRecordNotFoundException("No value available for query :".concat(query));
            }
            catch (SQLException ex) {
                throw new JKDataAccessException(ex.getMessage().concat(",".concat(query)), ex);
            }
        }
        catch (Throwable throwable) {
            this.close(rs, ps, con);
            throw throwable;
        }
    }

    @Override
    public <T> T findRecord(JKFinder finder) {
        ResultSet rs;
        PreparedStatement ps;
        Connection connection;
        block5: {
            connection = null;
            ps = null;
            rs = null;
            connection = this.getConnection(true);
            ps = this.prepareQueryStatement(connection, finder.getQuery(), new Object[0]);
            finder.setParamters(ps);
            this.logger.debug("findRecord, ps: ", ps);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Object t = finder.populate(rs);
            this.logger.debug("Object found : ", t);
            Object t2 = t;
            this.close(rs, ps, connection);
            return t2;
        }
        try {
            try {
                this.logger.debug("no rows found.");
                throw new JKRecordNotFoundException("REOCRD_NOT_FOUND");
            }
            catch (SQLException e) {
                throw new JKDataAccessException("Error while executing the following select statement : \n".concat(finder.getQuery()), e);
            }
        }
        catch (Throwable throwable) {
            this.close(rs, ps, connection);
            throw throwable;
        }
    }

    @Override
    public <T> T findRecord(JKFinder finder, String tableName, Object recordId) {
        if (objectsCache.get(tableName) == null) {
            objectsCache.put(tableName, new Hashtable());
        }
        try {
            Hashtable<Object, Object> tableCache = objectsCache.get(tableName);
            if (tableCache.get(recordId) == null) {
                T record = this.findRecord(finder);
                if (tableCache.size() > Integer.parseInt(this.getDataSource().getProperty("max-cache-size", "1000"))) {
                    return record;
                }
                tableCache.put(recordId, record);
            }
            return (T)tableCache.get(recordId);
        }
        catch (JKRecordNotFoundException e) {
            throw new JKRecordNotFoundException("RECORD_NOT_FOUND_FOR_TABLE (".concat(tableName).concat(") for ID (" + recordId + ")"));
        }
    }

    protected Connection getConnection() {
        return this.getConnection(false);
    }

    protected Connection getConnection(boolean query) {
        this.logger.debug("get connection with query flag : " + query);
        if (query) {
            return this.getDataSource().getQueryConnection();
        }
        return this.getDataSource().getConnection();
    }

    protected JKDataSource getDataSource() {
        return JKDataSourceFactory.getDefaultDataSource();
    }

    protected int getGeneratedKeys(PreparedStatement ps) throws SQLException {
        ResultSet idRs = ps.getGeneratedKeys();
        if (idRs.next()) {
            Object object = idRs.getObject(1);
            return JKConversionUtil.toInteger(object);
        }
        return 0;
    }

    protected Long getNextId(Connection connectoin, String tableName, String fieldName) throws JKDataAccessException {
        return this.getNextId(connectoin, tableName, fieldName, null);
    }

    protected Long getNextId(Connection con, String tableName, String fieldName, String condition) {
        PreparedStatement ps = null;
        try {
            String sql = JK.concat("SELECT MAX(", fieldName, ")+1 FROM ", tableName);
            if (condition != null && !condition.trim().equals("")) {
                sql = JK.concat(sql, " WHERE ", condition);
            }
            ps = this.prepareQueryStatement(con, sql, new Object[0]);
            Long id = 1L;
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
                if (rs.wasNull()) {
                    id = 1L;
                }
            } else {
                id = 1L;
            }
            Long l = id;
            this.close(ps);
            return l;
        }
        catch (SQLException e) {
            try {
                throw new JKDataAccessException(e);
            }
            catch (Throwable throwable) {
                this.close(ps);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getNextId(String tableName, String fieldName) {
        Connection connection = this.getConnection(true);
        try {
            Long l = this.getNextId(connection, tableName, fieldName);
            return l;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getNextId(String tableName, String fieldName, String condition) {
        Connection connection = this.getConnection(true);
        try {
            Long l = this.getNextId(connection, tableName, fieldName, condition);
            return l;
        }
        finally {
            this.close(connection);
        }
    }

    @Override
    public int getRowsCount(String query, Object ... params) {
        this.logger.debug(String.format("getRowsCount, Query(%s) ", query));
        String sql = JK.concat("SELECT COUNT(*) FROM (", query, ") ");
        return JKConversionUtil.toInteger(this.exeuteSingleOutputQuery(sql, params));
    }

    @Override
    public Date getSystemDate() {
        throw new IllegalStateException("not implemented for database : ".concat(this.getDataSource().getDatabaseType().toString()));
    }

    @Override
    public <T> List<T> getList(JKFinder finder) {
        this.logger.debug(String.format("executeUpdat, Query(%s) ", finder.getQuery()));
        Connection connection = null;
        Object ps = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection(true);
            ps = this.prepareQueryStatement(connection, finder.getQuery(), new Object[0]);
            finder.setParamters((PreparedStatement)ps);
            rs = ps.executeQuery();
            this.logger.debug(ps.toString().substring(ps.toString().toUpperCase().indexOf("SELECT")));
            Vector list = new Vector();
            while (rs.next()) {
                Object populate = finder.populate(rs);
                list.add(populate);
            }
            Vector vector = list;
            this.close(rs, (PreparedStatement)ps, connection);
            return vector;
        }
        catch (SQLException e) {
            try {
                if (ps != null) {
                    this.logger.error(ps.toString(), e);
                }
                throw new JKDataAccessException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, (PreparedStatement)ps, connection);
                throw throwable;
            }
        }
    }

    @Override
    public <T> List<T> getList(JKFinder finder, String key) {
        if (listsCache.get(key) == null) {
            listsCache.put(key, this.getList(finder));
        }
        return listsCache.get(key);
    }

    protected PreparedStatement prepareQueryStatement(Connection connection, String sql, Object ... params) throws SQLException {
        PreparedStatement prepareStatement = connection.prepareStatement(sql);
        return this.setParams(prepareStatement, params);
    }

    protected PreparedStatement prepareStatement(Connection connection, String sql, Object ... params) throws SQLException {
        PreparedStatement prepareStatement = connection.prepareStatement(sql);
        return this.setParams(prepareStatement, params);
    }

    protected PreparedStatement setParams(PreparedStatement prepareStatement, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            prepareStatement.setObject(i + 1, params[i]);
        }
        return prepareStatement;
    }

    protected void printRecordResultSet(ResultSet rs) {
        this.printRecordResultSet(rs, true, System.out);
    }

    protected void printRecordResultSet(ResultSet rs, boolean all, PrintStream out) {
        try {
            ResultSetMetaData meta = rs.getMetaData();
            out.println("At print result set");
            while (rs.next()) {
                out.println("------------------------------------------------------");
                for (int i = 0; i < meta.getColumnCount(); ++i) {
                    out.print(meta.getColumnName(i + 1) + " = " + rs.getObject(i + 1) + "\t");
                }
                out.println();
                if (all) continue;
                return;
            }
            out.println("///////////////////////");
        }
        catch (SQLException e) {
            throw new JKDataAccessException(e);
        }
    }

    public static void removeListCache(String query) {
        listsCache.remove(query);
    }

    public static synchronized void resetCache() {
        JKDataSourceFactory.getDefaultDataSource().resetCache();
    }

    @Override
    public <T> List<T> executeQueryAsObjectList(Class<T> clas, String query, Object ... params) {
        return this.executeQueryAsObjectList(clas, JKObjectUtil.getInstanceVariables(clas), query, params);
    }

    @Override
    public <T> List<T> executeQueryAsObjectList(Class<T> clas, String instanceProperyNames, String query, Object ... params) {
        Object[] rows;
        this.logger.debug(String.format("executeQueryAsObjectList, Class(%s), Properties(%s), Query(%s) , Params (%s)", clas.getSimpleName(), instanceProperyNames, query, Arrays.toString(params)));
        String[] properties = instanceProperyNames.split(",");
        Vector<T> results = new Vector<T>();
        for (Object rowObject : rows = this.executeQueryAsArray(query, params)) {
            Object[] row = (Object[])rowObject;
            T instance = JKObjectUtil.newInstance(clas);
            for (int i = 0; i < row.length; ++i) {
                JKObjectUtil.setPeopertyValue(instance, properties[i], row[i]);
            }
            results.add(instance);
        }
        return results;
    }

    @Override
    public <T> T executeQueryAsSingleObject(Class<T> clas, String query, Object ... params) {
        return this.executeQueryAsSingleObject(clas, JKObjectUtil.getInstanceVariables(clas), query, params);
    }

    @Override
    public <T> T executeQueryAsSingleObject(Class<T> clas, String instanceProperyNames, String query, Object ... params) {
        List<T> list = this.executeQueryAsObjectList(clas, instanceProperyNames, query, params);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new JKDataAccessException("results contains more than one row");
        }
        return list.get(0);
    }

    public void runScript(String fileName) {
        String query = JKIOUtil.readFile(fileName);
        this.execute(query, new Object[0]);
    }

    public boolean isTableExists(String tableName) {
        try {
            this.execute("select 1 from ".concat(tableName), new Object[0]);
            return true;
        }
        catch (JKDataAccessException e) {
            return false;
        }
    }
}

