/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dataaccess.orm;

import com.jk.db.dataaccess.exception.JKDataAccessManyRowsException;
import com.jk.db.dataaccess.orm.JKEntity;
import com.jk.db.dataaccess.orm.JKOrmDataAccess;
import com.jk.db.dataaccess.orm.meta.JKColumnWrapper;
import com.jk.db.dataaccess.orm.meta.JKSortInfo;
import com.jk.db.datasource.JKDataSourceFactory;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class JKJpaDataAccess
implements JKOrmDataAccess {
    JKLogger logger = JKLoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Object object) {
        EntityManager manager = this.getEntityManager();
        boolean commit = false;
        try {
            manager.persist(object);
            manager.flush();
            commit = true;
        }
        finally {
            this.close(manager, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Object object) {
        EntityManager manager = this.getEntityManager();
        boolean commit = false;
        try {
            manager.merge(object);
            manager.flush();
            commit = true;
        }
        finally {
            this.close(manager, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T find(Class<T> clas, Object id) {
        EntityManager manager = this.getEntityManager();
        try {
            T t = manager.find(clas, id);
            return t;
        }
        finally {
            JKDataSourceFactory.getDefaultDataSource().close(manager, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Object object) {
        EntityManager manager = this.getEntityManager();
        boolean commit = false;
        try {
            object = manager.merge(object);
            manager.remove(object);
            manager.flush();
            commit = true;
        }
        finally {
            this.close(manager, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Object id, Class<?> type) {
        EntityManager manager = this.getEntityManager();
        boolean commit = false;
        try {
            Object object = manager.find(type, id);
            manager.remove(object);
            manager.flush();
            commit = true;
        }
        finally {
            this.close(manager, commit);
        }
    }

    @Override
    public <T> List<T> getList(Class<T> clas) {
        this.logger.debug("getList : " + clas.getName());
        return this.getList(clas, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getList(Class<T> clas, Map<String, Object> paramters) {
        this.logger.debug("getList : " + clas.getName() + " , with params : " + paramters);
        EntityManager manager = this.getEntityManager();
        try {
            StringBuffer buf = new StringBuffer("SELECT c FROM ".concat(clas.getSimpleName()).concat(" c "));
            buf.append(" WHERE 1=1 ");
            if (paramters != null) {
                Set<String> keySet = paramters.keySet();
                for (String paramName : keySet) {
                    buf.append(String.format(" AND c.%s=?", paramName));
                }
                List<T> list = this.executeQuery(clas, buf.toString(), paramters.values().toArray());
                return list;
            }
            List<T> list = this.executeQuery(clas, buf.toString(), new Object[0]);
            return list;
        }
        finally {
            this.close(manager, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> executeQuery(Class<T> clas, String queryString, Object ... paramters) {
        this.logger.debug("executeQuery for class : " + clas.getName() + " with query : " + queryString + " , params : " + Arrays.toString(paramters));
        EntityManager em = this.getEntityManager();
        try {
            Vector vector;
            Query query = em.createQuery(queryString);
            for (int i = 0; i < paramters.length; ++i) {
                Object object = paramters[i];
                query.setParameter(i + 1, object);
            }
            Vector resultList = query.getResultList();
            if (resultList == null) {
                vector = new Vector();
                return vector;
            }
            vector = resultList;
            return vector;
        }
        finally {
            this.close(em, true);
        }
    }

    private void close(EntityManager manager, boolean commit) {
        JKDataSourceFactory.getDefaultDataSource().close(manager, commit);
    }

    protected EntityManager getEntityManager() {
        EntityManager manager = JKDataSourceFactory.getDefaultDataSource().createEntityManager();
        return manager;
    }

    protected String getQueryOrder(Class<? extends JKEntity> clas) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = clas.getMethod("getSortInfo", Class.class);
        JKSortInfo info = (JKSortInfo)method.invoke(null, clas);
        StringBuffer buf2 = new StringBuffer();
        if (info != null) {
            buf2.append("ORDER BY ");
            JKColumnWrapper col = (JKColumnWrapper)info.column();
            buf2.append("c." + col.getFieldName());
            buf2.append(" " + info.sortOrder().toString());
        }
        return buf2.toString();
    }

    public <T> T findSingleEntity(Class<T> clas, String queryString, Object ... paramters) {
        List<T> list = this.executeQuery(clas, queryString, paramters);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new JKDataAccessManyRowsException(queryString, paramters);
    }

    public <T extends JKEntity> T getFirstRecord(Class<T> clas) {
        List<T> all = this.getList(clas);
        if (all.size() > 0) {
            return (T)((JKEntity)all.get(0));
        }
        return null;
    }
}

