/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dataaccess.orm;

import com.jk.db.dataaccess.orm.meta.JKColumnWrapper;
import com.jk.db.dataaccess.orm.meta.JKSortDirection;
import com.jk.db.dataaccess.orm.meta.JKSortInfo;
import com.jk.util.JKObjectUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

public class JKEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;

    public String getTableName() {
        Table annotation = this.getClass().getAnnotation(Table.class);
        return annotation.name();
    }

    public <T> T getIdValue() {
        return JKObjectUtil.getPropertyValue(this, this.getIdColumn().getFieldName());
    }

    public Column getFirstNonIdColumn() {
        Field[] declaredFields;
        for (Field field : declaredFields = this.getClass().getDeclaredFields()) {
            Column column;
            if (field.getAnnotation(Id.class) != null || (column = field.getAnnotation(Column.class)) == null) continue;
            return new JKColumnWrapper(field, column);
        }
        return null;
    }

    public static List<JKColumnWrapper> getColumns(Class<? extends JKEntity> clas) {
        Field[] declaredFields = clas.getDeclaredFields();
        Vector<JKColumnWrapper> columns = new Vector<JKColumnWrapper>();
        for (Field field : declaredFields) {
            Column column = field.getAnnotation(Column.class);
            Id id = field.getAnnotation(Id.class);
            JKSortInfo sortInfo = field.getAnnotation(JKSortInfo.class);
            if (column == null) continue;
            JKColumnWrapper wrapper = new JKColumnWrapper(field, column);
            wrapper.setId(id);
            wrapper.setSortInfo(JKEntity.addColumnToSortInfo(wrapper, sortInfo));
            columns.add(wrapper);
        }
        return columns;
    }

    private static JKSortInfo addColumnToSortInfo(final JKColumnWrapper wrapper, final JKSortInfo sortInfo) {
        if (sortInfo == null) {
            return null;
        }
        JKSortInfo info = new JKSortInfo(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return sortInfo.annotationType();
            }

            @Override
            public JKSortDirection sortOrder() {
                return sortInfo.sortOrder();
            }

            @Override
            public Column column() {
                return wrapper;
            }
        };
        return info;
    }

    public JKColumnWrapper getIdColumn() {
        return JKEntity.getIdColumn(this.getClass());
    }

    public static JKColumnWrapper getIdColumn(Class<? extends JKEntity> clas) {
        for (JKColumnWrapper col : JKEntity.getColumns(clas)) {
            if (!col.isId()) continue;
            return col;
        }
        return null;
    }

    public void printFieldsAnnotations() {
        Field[] declaredFields;
        for (Field field : declaredFields = this.getClass().getDeclaredFields()) {
            JKEntity.printFieldAnnotations(field);
        }
    }

    public static void printFieldAnnotations(Field field) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field.getAnnotations()) {
            System.out.println(annotation);
        }
    }

    public String toString() {
        List<JKColumnWrapper> columns = JKEntity.getColumns(this.getClass());
        StringBuffer buf = new StringBuffer();
        buf.append(this.getAliasName());
        buf.append("[");
        int i = 0;
        for (JKColumnWrapper column : columns) {
            if (column.getFieldName().toLowerCase().contains("password")) continue;
            if (i++ > 0) {
                buf.append(",");
            }
            buf.append(column.name());
            buf.append("=");
            buf.append(JKObjectUtil.getPropertyValue(this, column.getFieldName()));
        }
        buf.append("]\n");
        return buf.toString();
    }

    public static JKSortInfo getSortInfo(Class<? extends JKEntity> clas) {
        for (JKColumnWrapper column : JKEntity.getColumns(clas)) {
            if (column.getSortInfo() == null) continue;
            return column.getSortInfo();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JKEntity)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        JKEntity that = (JKEntity)obj;
        return this.getTableName().equals(that.getTableName()) && this.getIdValue() != null && this.getIdValue().equals(that.getIdValue());
    }

    public int hashCode() {
        int hashcode = this.getIdValue().hashCode();
        return hashcode;
    }

    public String getAliasName() {
        return this.getClass().getSimpleName();
    }
}

