/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.dataaccess.oracle;

import com.jk.db.dataaccess.plain.JKAbstractPlainDataAccess;
import com.jk.db.dataaccess.plain.JKFinder;
import com.jk.exceptions.JKDataAccessException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class OracleAbstractDao
extends JKAbstractPlainDataAccess {
    public static byte[] blobToByteArray(Blob blob) throws IOException, SQLException {
        int inByte;
        InputStream inputStream = blob.getBinaryStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((inByte = inputStream.read()) != -1) {
            byteArrayOutputStream.write(inByte);
        }
        byte[] returnBytes = byteArrayOutputStream.toByteArray();
        return returnBytes;
    }

    public int getNextSequence(String squenceName) {
        Object output = super.exeuteSingleOutputQuery("SELECT " + squenceName + ".NEXTVAL from DUAL", new Object[0]);
        if (output instanceof Integer || output instanceof Long) {
            return new Integer(output.toString());
        }
        throw new JKDataAccessException("Unable to get sequence of sequence : " + squenceName + " , value returned " + output);
    }

    @Override
    public Timestamp getSystemDate() {
        JKFinder finder = new JKFinder(){

            @Override
            public String getQuery() {
                return "SELECT SYSTIMESTAMP FROM DUAL";
            }

            public Object populate(ResultSet rs) throws SQLException {
                Timestamp date = rs.getTimestamp(1);
                return date;
            }

            @Override
            public void setParamters(PreparedStatement ps) throws SQLException {
            }
        };
        return (Timestamp)this.findRecord(finder);
    }

    protected boolean isDuplicateKey(SQLException e) throws SQLException {
        return this.isDuplicateKey(e, true);
    }

    protected boolean isDuplicateKey(SQLException e, boolean throwException) throws SQLException {
        if (e.getErrorCode() == 1) {
            return true;
        }
        if (throwException) {
            throw e;
        }
        return false;
    }
}

