/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.analayzer.gui;

import com.jk.db.analayzer.gui.ConstraintPanel;
import com.jk.db.analayzer.gui.FieldPanel;
import com.jk.db.analayzer.gui.PnlTriggers;
import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKCheckBox;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.panels.JKLabledComponent;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.swing.text.documents.NumberDocument;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.TableMeta;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TableMetaPanel
extends JKPanel<Object> {
    private static final long serialVersionUID = 1L;
    JTextArea txtReportSql = new JTextArea(5, 50);
    JTextArea txtListSql = new JTextArea(2, 50);
    JTextArea txtShortSql = new JTextArea(3, 50);
    JKTextField txtTableId = new JKTextField(20);
    JKTextField txtMaxRecordCount = new JKTextField(new NumberDocument(2L), 20);
    private final TableMeta meta;
    ArrayList<ConstraintPanel> constraintsPanels = new ArrayList();
    private final JKPanel<?> pnlConstraints = new JKPanel();
    JList<String> lstFields = new JList();
    Hashtable<String, TableMeta> tablesHash;
    JKCheckBox chkAllowManage = new JKCheckBox("Allow Manage");
    JKTextField txtCaption = new JKTextField(20);
    JKTextField txtIconName = new JKTextField(20);
    JKTextField txtPageRowCount = new JKTextField(20);
    JKTextField txtFiltersPanel = new JKTextField(20);
    JKTextField txtPanelClass = new JKTextField(50);
    JKTextField txtUIColnmCount = new JKTextField(50);
    JKCheckBox rdAllowAdd = new JKCheckBox("Allow Add");
    JKCheckBox rdAllowUpdate = new JKCheckBox("Allow Update");
    JKCheckBox rdAllowDelete = new JKCheckBox("Allow Delete");
    JKButton btnSave = new JKButton("Save");
    JKButton btnCancel = new JKButton("Cancel");
    JKButton btnTriggers = new JKButton("triggers");
    JKButton btnAddConstraint = new JKButton("Add Constraint");

    public TableMetaPanel(TableMeta meta, Hashtable<String, TableMeta> tablesHash) {
        this.meta = meta;
        this.tablesHash = tablesHash;
        this.modelToView();
        this.init();
    }

    private JKPanel<?> getButtonsPanel() {
        JKPanel pnlButtons = new JKPanel();
        pnlButtons.add(this.btnTriggers);
        pnlButtons.add(this.btnSave);
        pnlButtons.add(this.btnCancel);
        return pnlButtons;
    }

    private JKPanel<?> getConstraintsPanel() {
        int i;
        for (i = 0; i < this.meta.getConstraints().size(); ++i) {
            this.constraintsPanels.add(new ConstraintPanel(this.meta, this.meta.getConstraints().get(i)));
        }
        this.pnlConstraints.setLayout(new BoxLayout(this.pnlConstraints, 1));
        this.pnlConstraints.add(this.btnAddConstraint);
        for (i = 0; i < this.constraintsPanels.size(); ++i) {
            this.pnlConstraints.add(this.constraintsPanels.get(i));
        }
        return this.pnlConstraints;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JKPanel pnlMain = new JKPanel();
        pnlMain.setLayout(new BoxLayout(pnlMain, 1));
        JScrollPane fieldsPane = new JScrollPane(this.lstFields, 22, 32);
        JScrollPane reportPane = new JScrollPane(this.txtReportSql, 22, 32);
        JScrollPane txtListPane = new JScrollPane(this.txtListSql, 22, 32);
        JScrollPane txtShortPane = new JScrollPane(this.txtShortSql, 22, 32);
        fieldsPane.setBorder(BorderFactory.createTitledBorder("Fields list"));
        reportPane.setBorder(BorderFactory.createTitledBorder("Detailed Report SQL"));
        txtListPane.setBorder(BorderFactory.createTitledBorder("Combo Box SQL"));
        txtShortPane.setBorder(BorderFactory.createTitledBorder("Basic Info SQL"));
        JKPanel<?> pnlButtons = this.getButtonsPanel();
        pnlMain.add(new JKLabledComponent("Table Id", (BindingComponent)this.txtTableId));
        pnlMain.add(new JKLabledComponent("Filter fields", (BindingComponent)this.txtFiltersPanel));
        pnlMain.add(new JKLabledComponent("Caption", (BindingComponent)this.txtCaption));
        pnlMain.add(new JKLabledComponent("Max Record Count ", (BindingComponent)this.txtMaxRecordCount));
        pnlMain.add(new JKLabledComponent("Icon name", (BindingComponent)this.txtIconName));
        pnlMain.add(new JKLabledComponent("Page Count", (BindingComponent)this.txtPageRowCount));
        pnlMain.add(new JKLabledComponent("Panel class", (BindingComponent)this.txtPanelClass));
        pnlMain.add(new JKLabledComponent("UI-Column-Count", (BindingComponent)this.txtUIColnmCount));
        JKPanel pnlCheckBoxes = new JKPanel();
        pnlCheckBoxes.add(this.chkAllowManage);
        pnlCheckBoxes.add(this.rdAllowAdd);
        pnlCheckBoxes.add(this.rdAllowUpdate);
        pnlCheckBoxes.add(this.rdAllowDelete);
        pnlMain.add(pnlCheckBoxes);
        pnlMain.add(fieldsPane);
        pnlMain.add(reportPane);
        pnlMain.add(txtListPane);
        pnlMain.add(txtShortPane);
        pnlMain.add(pnlButtons);
        this.add(pnlMain, "Center");
        this.add((Component)new JScrollPane(this.getConstraintsPanel()), "East");
        this.btnTriggers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PnlTriggers pnl = new PnlTriggers(TableMetaPanel.this.meta.getTriggerNames());
                SwingUtility.showPanelInDialog(pnl, "triggers");
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableMetaPanel.this.viewToModel();
                SwingUtility.closePanelDialog(TableMetaPanel.this);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtility.closePanelDialog(TableMetaPanel.this);
            }
        });
        this.btnAddConstraint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintPanel pnl = new ConstraintPanel(TableMetaPanel.this.meta);
                SwingUtility.showPanelInDialog(pnl, "Add Constraint");
                TableMetaPanel.this.pnlConstraints.removeAll();
                TableMetaPanel.this.getConstraintsPanel();
                TableMetaPanel.this.pnlConstraints.validate();
                TableMetaPanel.this.pnlConstraints.repaint();
                SwingUtility.packWindow(TableMetaPanel.this);
            }
        });
        this.lstFields.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    TableMetaPanel.this.showSelectedField();
                }
            }
        });
        this.lstFields.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    TableMetaPanel.this.showSelectedField();
                }
            }
        });
    }

    private void modelToView() {
        this.txtTableId.setText(this.meta.getTableId());
        this.txtReportSql.setText(this.meta.getReportSql());
        this.txtListSql.setText(this.meta.getListSql());
        this.txtShortSql.setText(this.meta.getShortReportSql());
        this.txtMaxRecordCount.setText(this.meta.getMaxRecordsCount() + "");
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.lstFields.setModel(model);
        model.addElement(this.meta.getIdField().getName());
        for (int i = 0; i < this.meta.getFieldList().size(); ++i) {
            model.addElement(this.meta.getFieldList().get(i).getName());
        }
        this.chkAllowManage.setSelected(this.meta.isAllowManage());
        if (this.meta.getIconName() != null) {
            this.txtIconName.setText(this.meta.getIconName());
        }
        this.txtCaption.setText(this.meta.getCaption());
        this.txtPageRowCount.setText(this.meta.getPageRowCount() + "");
        this.txtFiltersPanel.setText(this.meta.getFiltersAsString());
        this.txtPanelClass.setText(this.meta.getPanelClassName());
        this.txtUIColnmCount.setText(this.meta.getDefaultUIRowCount() + "");
        this.rdAllowAdd.setSelected(this.meta.isAllowAdd());
        this.rdAllowDelete.setSelected(this.meta.isAllowDelete());
        this.rdAllowUpdate.setSelected(this.meta.isAllowUpdate());
    }

    protected void showSelectedField() {
        int index = this.lstFields.getSelectedIndex();
        if (index != -1) {
            FieldMeta field = this.meta.getField(this.lstFields.getSelectedValue(), true);
            FieldPanel panel = new FieldPanel(field, this.tablesHash);
            SwingUtility.showPanelInDialog(panel, "");
        }
    }

    private void viewToModel() {
        this.meta.setTableId(this.txtTableId.getText().trim());
        this.meta.setReportSql(this.txtReportSql.getText().trim());
        this.meta.setListSql(this.txtListSql.getText().trim());
        this.meta.setShortReportSql(this.txtShortSql.getText().trim());
        try {
            this.meta.setMaxRecordsCount(Integer.parseInt(this.txtMaxRecordCount.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.meta.setAllowManage(this.chkAllowManage.isSelected());
        if (!this.txtIconName.getText().equals("")) {
            this.meta.setIconName(this.txtIconName.getText());
        } else {
            this.meta.setIconName(null);
        }
        this.meta.setCaption(this.txtCaption.getText());
        if (!this.txtPageRowCount.getText().equals("")) {
            this.meta.setPageRowCount(Integer.parseInt(this.txtPageRowCount.getText()));
        }
        if (!this.txtFiltersPanel.getText().equals("")) {
            this.meta.setFilters(this.txtFiltersPanel.getText().split(","));
        }
        if (!this.txtUIColnmCount.getText().trim().equals("")) {
            this.meta.setDefaultUIRowCount(this.txtUIColnmCount.getTextAsInteger());
        }
        this.meta.setPanelClassName(this.txtPanelClass.getText().trim());
        this.meta.setAllowAdd(this.rdAllowAdd.isSelected());
        this.meta.setAllowDelete(this.rdAllowDelete.isSelected());
        this.meta.setAllowUpdate(this.rdAllowUpdate.isSelected());
    }
}

