/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.analayzer.gui;

import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.panels.JKPanel;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BoxLayout;

public class PnlTriggers
extends JKPanel<Object> {
    private static final long serialVersionUID = 1L;
    private final Collection<String> triggersNames;
    ArrayList<JKTextField> cmbTriggers = new ArrayList();
    private JKPanel<?> pnlTriggers;
    JKButton btnAdd = new JKButton("add");
    JKButton btnSave = new JKButton("save");
    JKButton btnClose = new JKButton("close");

    public static void main(String[] args) {
        ArrayList<String> triggers = new ArrayList<String>();
        PnlTriggers pnl = new PnlTriggers(triggers);
        SwingUtility.showPanelInDialog(pnl, "");
        System.out.println(triggers);
    }

    public PnlTriggers(Collection<String> triggers) {
        this.triggersNames = triggers;
        this.init();
    }

    private void addTrigger(String name) {
        JKTextField txt = new JKTextField();
        txt.setText(name);
        this.cmbTriggers.add(txt);
        this.pnlTriggers.add(txt);
    }

    private JKPanel<?> getButtonsPanel() {
        JKPanel pnlButtons = new JKPanel();
        pnlButtons.add(this.btnAdd);
        pnlButtons.add(this.btnSave);
        pnlButtons.add(this.btnClose);
        return pnlButtons;
    }

    private JKPanel<?> getTriggersPanel() {
        if (this.pnlTriggers == null) {
            this.pnlTriggers = new JKPanel();
            this.pnlTriggers.setLayout(new BoxLayout(this.pnlTriggers, 1));
            for (String triggersName : this.triggersNames) {
                this.addTrigger(triggersName);
            }
        }
        return this.pnlTriggers;
    }

    protected void handleAdd() {
        String triggerName = SwingUtility.showInputDialog("Enter trigger Name");
        this.addTrigger(triggerName);
        this.pnlTriggers.validate();
        this.pnlTriggers.repaint();
        SwingUtility.packWindow(this);
    }

    protected void handleClose() {
        SwingUtility.closePanelDialog(this);
    }

    protected void handleSave() {
        this.triggersNames.clear();
        for (int i = 0; i < this.cmbTriggers.size(); ++i) {
            String triggerName = this.cmbTriggers.get(i).getText().trim();
            if (triggerName.equals("")) continue;
            this.triggersNames.add(triggerName);
        }
        this.handleClose();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getTriggersPanel(), "Center");
        this.add(this.getButtonsPanel(), "South");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PnlTriggers.this.handleAdd();
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PnlTriggers.this.handleSave();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PnlTriggers.this.handleClose();
            }
        });
    }
}

