/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.analayzer.gui;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKCheckBox;
import com.jk.desktop.swing.comp.JKComboBox;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.panels.JKLabledComponent;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.swing.text.documents.NumberDocument;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.ForiegnKeyFieldMeta;
import com.jk.metadata.db.meta.IdFieldMeta;
import com.jk.metadata.db.meta.TableMeta;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;

public class FieldPanel
extends JKPanel<Object> {
    private static final long serialVersionUID = 1L;
    private final FieldMeta fieldMeta;
    private final JKTextField txtName = new JKTextField(15);
    private final JKTextField txtCaption = new JKTextField(15);
    private final JKTextField txtType = new JKTextField(new NumberDocument(3L), 15);
    private final JKTextField txtWidth = new JKTextField(new NumberDocument(3L), 15);
    JKTextField txtDefaultValue = new JKTextField(20);
    private final JKCheckBox chkAllowUpdate = new JKCheckBox("Allow update");
    private final JKTextField txtMaxLength = new JKTextField(new NumberDocument(3L), 15);
    private final JKCheckBox chkCofirmInput = new JKCheckBox("");
    private final JKCheckBox chkRequired = new JKCheckBox("");
    private final JKCheckBox chkVisible = new JKCheckBox("");
    private final JKComboBox cmbReferenceTable = new JKComboBox();
    private final JKComboBox cmbReferenceField = new JKComboBox();
    private final JKComboBox cmbReleation = new JKComboBox();
    private final JKCheckBox chkAutoIncrement = new JKCheckBox("");
    private final JKCheckBox chkEnabled = new JKCheckBox("");
    private final JKCheckBox chkSummaryFild = new JKCheckBox("");
    JKButton btnSave = new JKButton("Save");
    JKButton btnCancel = new JKButton("Cancel");
    private final Hashtable<String, TableMeta> tablesHash;
    JKComboBox cmbViewMode = new JKComboBox();

    public FieldPanel(FieldMeta fieldMeta, Hashtable<String, TableMeta> tablesHash) {
        this.fieldMeta = fieldMeta;
        this.tablesHash = tablesHash;
        this.cmbReleation.addItem(ForiegnKeyFieldMeta.Relation.ONE_TO_ONE);
        this.cmbReleation.addItem(ForiegnKeyFieldMeta.Relation.ONE_TO_MANY);
        this.cmbReleation.addItem(ForiegnKeyFieldMeta.Relation.MANY_TO_ONE);
        this.cmbReleation.addItem(ForiegnKeyFieldMeta.Relation.MANY_TO_MANY);
        this.cmbReleation.addItem(ForiegnKeyFieldMeta.Relation.ONE_TO_ONE);
        this.cmbViewMode.addItem(ForiegnKeyFieldMeta.ViewMode.COMBO);
        this.cmbViewMode.addItem(ForiegnKeyFieldMeta.ViewMode.LIST);
        this.cmbViewMode.addItem(ForiegnKeyFieldMeta.ViewMode.DIALOG);
        Enumeration<String> enu = tablesHash.keys();
        while (enu.hasMoreElements()) {
            TableMeta tableMeta = tablesHash.get(enu.nextElement());
            this.cmbReferenceTable.addItem(tableMeta.getTableId());
        }
        this.init();
        this.txtName.setEnabled(false);
        this.cmbReferenceField.setEnabled(false);
        this.cmbReferenceTable.setEnabled(false);
        this.modelToView();
    }

    private JKPanel<?> getForiegnKeyPanel() {
        JKPanel panel = new JKPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JKLabledComponent("Reference table", (BindingComponent)this.cmbReferenceTable));
        panel.add(new JKLabledComponent("Reference field", (BindingComponent)this.cmbReferenceField));
        panel.add(new JKLabledComponent("Releation", (BindingComponent)this.cmbReleation));
        panel.add(new JKLabledComponent("View Mode", (BindingComponent)this.cmbViewMode));
        return panel;
    }

    private JKPanel<?> getIdFieldPanel() {
        JKPanel panel = new JKPanel();
        panel.add(new JKLabledComponent("Auto increment", (BindingComponent)this.chkAutoIncrement));
        return panel;
    }

    protected void handleCancel() {
        SwingUtility.closePanelDialog(this);
    }

    protected void handleSave() {
        this.viewToModel();
        SwingUtility.closePanelDialog(this);
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        if (this.fieldMeta instanceof IdFieldMeta) {
            this.add(this.getIdFieldPanel());
        }
        this.add(new JKLabledComponent("Name", (BindingComponent)this.txtName));
        this.add(new JKLabledComponent("Caption", (BindingComponent)this.txtCaption));
        this.add(new JKLabledComponent("Max length", (BindingComponent)this.txtMaxLength));
        this.add(new JKLabledComponent("Type", (BindingComponent)this.txtType));
        this.add(new JKLabledComponent("UI Width", (BindingComponent)this.txtWidth));
        this.add(new JKLabledComponent("Default Value", (BindingComponent)this.txtDefaultValue));
        this.add(new JKLabledComponent("Allow update", (BindingComponent)this.chkAllowUpdate));
        this.add(new JKLabledComponent("Confirm User Input", (BindingComponent)this.chkCofirmInput));
        this.add(new JKLabledComponent("Required", (BindingComponent)this.chkRequired));
        this.add(new JKLabledComponent("Visible", (BindingComponent)this.chkVisible));
        this.add(new JKLabledComponent("Enabled", (BindingComponent)this.chkEnabled));
        this.add(new JKLabledComponent("Summary Field", (BindingComponent)this.chkSummaryFild));
        if (this.fieldMeta instanceof ForiegnKeyFieldMeta) {
            this.add(this.getForiegnKeyPanel());
        }
        JKPanel pnlButtons = new JKPanel();
        pnlButtons.add(this.btnSave);
        pnlButtons.add(this.btnCancel);
        this.add(pnlButtons);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldPanel.this.handleSave();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldPanel.this.handleCancel();
            }
        });
    }

    private void loadTableFields(String tableName) {
        this.cmbReferenceField.removeAllItems();
        TableMeta meta = this.tablesHash.get(tableName);
        for (int i = 0; i < meta.getFieldList().size(); ++i) {
            this.cmbReferenceField.addItem(meta.getFieldList().get(i).getName());
        }
    }

    private void modelToView() {
        if (this.fieldMeta instanceof IdFieldMeta) {
            this.chkAutoIncrement.setSelected(((IdFieldMeta)this.fieldMeta).isAutoIncrement());
        }
        this.txtMaxLength.setText(this.fieldMeta.getMaxLength() + "");
        this.txtName.setText(this.fieldMeta.getName());
        this.txtType.setText(this.fieldMeta.getType() + "");
        this.txtWidth.setText(this.fieldMeta.getWidth() + "");
        this.chkAllowUpdate.setSelected(this.fieldMeta.isAllowUpdate());
        this.chkCofirmInput.setSelected(this.fieldMeta.isConfirmInput());
        this.chkRequired.setSelected(this.fieldMeta.isRequired());
        this.chkVisible.setSelected(this.fieldMeta.isVisible());
        this.chkEnabled.setSelected(this.fieldMeta.isEnabled());
        this.chkSummaryFild.setSelected(this.fieldMeta.isSummaryField());
        this.txtDefaultValue.setText(this.fieldMeta.getDefaultValue());
        if (this.fieldMeta instanceof ForiegnKeyFieldMeta) {
            ForiegnKeyFieldMeta fk = (ForiegnKeyFieldMeta)this.fieldMeta;
            this.cmbReferenceTable.setSelectedItem(fk.getReferenceTable());
            this.loadTableFields(fk.getReferenceTable());
            this.cmbReferenceField.setSelectedItem(fk.getReferenceField());
            this.cmbReleation.setSelectedItem(fk.getRelation());
            this.cmbViewMode.setSelectedItem(fk.getViewMode());
        }
        if (this.fieldMeta.getCaption() != null) {
            this.txtCaption.setText(this.fieldMeta.getCaption());
        }
    }

    private void viewToModel() {
        if (this.fieldMeta instanceof IdFieldMeta) {
            ((IdFieldMeta)this.fieldMeta).setAutoIncrement(this.chkAutoIncrement.isSelected());
        }
        this.fieldMeta.setMaxLength(Integer.parseInt(this.txtMaxLength.getText()));
        this.fieldMeta.setType(Integer.parseInt(this.txtType.getText()));
        this.fieldMeta.setWidth(Integer.parseInt(this.txtWidth.getText()));
        this.fieldMeta.setAllowUpdate(this.chkAllowUpdate.isSelected());
        this.fieldMeta.setConfirmInput(this.chkCofirmInput.isSelected());
        this.fieldMeta.setRequired(this.chkRequired.isSelected());
        this.fieldMeta.setVisible(this.chkVisible.isSelected());
        this.fieldMeta.setEnabled(this.chkEnabled.isSelected());
        this.fieldMeta.setDefaultValue(this.txtDefaultValue.getText().trim());
        if (this.fieldMeta instanceof ForiegnKeyFieldMeta) {
            ForiegnKeyFieldMeta fk = (ForiegnKeyFieldMeta)this.fieldMeta;
            fk.setRelation((ForiegnKeyFieldMeta.Relation)this.cmbReleation.getSelectedItem());
            fk.setViewMode((ForiegnKeyFieldMeta.ViewMode)this.cmbViewMode.getSelectedItem());
        }
        this.fieldMeta.setCaption(this.txtCaption.getText());
        this.fieldMeta.setSummaryField(this.chkSummaryFild.isSelected());
    }
}

