/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.analayzer.gui;

import com.jk.db.analayzer.gui.TableMetaPanel;
import com.jk.db.datasource.JKDataSource;
import com.jk.db.datasource.JKDataSourceFactory;
import com.jk.db.dynamic.DynamicDaoFactory;
import com.jk.db.dynamic.meta.AbstractTableMetaFactory;
import com.jk.db.dynamic.meta.TableMetaFactory;
import com.jk.db.dynamic.meta.generator.DataBaseAnalayzer;
import com.jk.db.dynamic.meta.xml.JKXmlException;
import com.jk.db.dynamic.meta.xml.TableMetaXMLGenerator;
import com.jk.db.util.JdbcUtil;
import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKCheckBox;
import com.jk.desktop.swing.comp.JKComboBox;
import com.jk.desktop.swing.comp.JKFrame;
import com.jk.desktop.swing.comp.JKLabel;
import com.jk.desktop.swing.comp.JKTable;
import com.jk.desktop.swing.comp.JKTextArea;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.panels.JKLabledComponent;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.swing.listener.RecordSelectionListener;
import com.jk.desktop.util.JKComponentFactory;
import com.jk.exceptions.JKDataAccessException;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.TableMeta;
import com.jk.util.JKIOUtil;
import com.jk.util.model.table.JKTableColumn;
import com.jk.util.model.table.JKTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;

public class DataBaseAnalyzerFrame
extends JKFrame {
    private static final long serialVersionUID = 1L;
    private DataBaseAnalayzer analyzer;
    private Hashtable<String, TableMeta> tablesHash;
    JKComboBox cmbCatalogs = new JKComboBox();
    JKButton btnSelectAll = new JKButton("Select ALL");
    JKButton btnDeSelectAll = new JKButton("DeSelect ALL");
    JKButton btnGenerate = new JKButton("Generate XML");
    JKButton btnParse = new JKButton("Parse XML");
    JKButton btnLoad = new JKButton("Load XML");
    JKButton btnSave = new JKButton("Save");
    JKButton btnCompare = new JKButton("Compare");
    JKButton btnShowLables = new JKButton("Show Lables");
    JKTextArea txtResult = new JKTextArea(30, 30);
    JKTableModel mdlTables = new JKTableModel();
    JKTable tblTables = new JKTable(this.mdlTables);
    JFileChooser chooser = new JFileChooser(".");
    private JKDataSource dataSource;
    private JKLogger logger = JKLoggerFactory.getLogger(this.getClass());
    private final JPanel pnlDatabase = new JPanel();
    private final JKLabel lblUrl = new JKLabel("DB URL");
    private final JKTextField txtDriver = new JKTextField();
    private final JKTextField txtUrl = new JKTextField();
    private final JKLabel lblDriver = new JKLabel("DB Driver");
    private final JKLabel lblUser = new JKLabel("Username");
    private final JKTextField txtUser = new JKTextField();
    private final JKLabel lblPassword = new JKLabel("Password");
    private final JPasswordField txtPassword = new JPasswordField();
    private final JKButton btnPing = new JKButton("Ping");
    private final JKButton btnConnect = new JKButton("Connect");
    private final JKButton btnSelectDriver = new JKButton("Select");
    private final JButton btnResetDb = new JButton("Reset");
    private final JPanel northContainer = new JPanel();
    private boolean inProgress;

    public DataBaseAnalyzerFrame() {
        super("Database Analayzer by Jalal Kiswani ..::::... http://www.JalalKiswani.com");
        this.init();
        this.populateDatabaseConfigPanel();
        this.loadPath();
        this.btnConnect.requestFocus();
    }

    void cachePath(String fileName) {
        JKIOUtil.writeDataToFile(fileName.getBytes(), new File("oldpath.txt"));
    }

    private String getCurrentCatalogName() {
        return (String)this.cmbCatalogs.getSelectedItem();
    }

    private TableMetaFactory getMetaFactory() {
        return AbstractTableMetaFactory.getDefaultMetaFactory();
    }

    private ArrayList<TableMeta> getSelectedTablesMeta() {
        ArrayList<TableMeta> selectedTablesMeta = new ArrayList<TableMeta>();
        for (int i = 0; i < this.tblTables.getRowCount(); ++i) {
            Boolean selected = this.tblTables.getValueAtAsBoolean(i, 0);
            if (!selected.booleanValue()) continue;
            String tableName = this.tblTables.getValueAtAsString(i, 1);
            selectedTablesMeta.add(this.tablesHash.get(tableName));
        }
        return selectedTablesMeta;
    }

    int getTableMetaRowIndex(String tableName) {
        return this.tblTables.findValueRowIndex(1, tableName);
    }

    String getTableName(int rowId) {
        return this.tblTables.getValueAtAsString(rowId, 1);
    }

    protected void handleCompare() {
        List<TableMeta> databaseTables = this.analyzer.getTablesMeta(this.getCurrentCatalogName());
        for (int i = 0; i < databaseTables.size(); ++i) {
            TableMeta databaseMeta = databaseTables.get(i);
            TableMeta currentTableMeta = this.tablesHash.get(databaseMeta.getTableName());
            if (currentTableMeta == null) {
                this.logger.info("Table  : " + databaseMeta.getTableName() + " exists in the database and doesnot exist the current meta");
                continue;
            }
            this.logger.info("Comparing Table  : " + currentTableMeta.getTableName());
            Vector<FieldMeta> databaseTableFields = databaseMeta.getFieldList();
            databaseMeta.getFieldList();
            for (int j = 0; j < databaseTableFields.size(); ++j) {
                String fildName = ((FieldMeta)databaseTableFields.get(i)).getName();
                FieldMeta field = currentTableMeta.getField(fildName);
                if (field != null) continue;
                this.logger.info("Field : " + fildName + " doesnot exist");
            }
        }
    }

    protected void handleDatabaseChanged() {
        if (this.inProgress) {
            return;
        }
        String currentCatalogName = this.getCurrentCatalogName();
        if (currentCatalogName != null && !currentCatalogName.equals("")) {
            List<TableMeta> tables = this.analyzer.getTablesMeta(currentCatalogName);
            this.tablesHash = new Hashtable();
            this.mdlTables.clearRecords();
            for (int i = 0; i < tables.size(); ++i) {
                TableMeta table = tables.get(i);
                this.tablesHash.put(table.getTableName(), table);
                this.tblTables.addRow(new Object[]{new Boolean(false), table.getTableName()});
            }
            this.tblTables.setSelectedRow(0);
        }
    }

    protected void handleGenerate() {
        TableMetaXMLGenerator generator = new TableMetaXMLGenerator();
        ArrayList<TableMeta> selectedTablesMeta = this.getSelectedTablesMeta();
        String result = generator.generateTablesMetaXml(selectedTablesMeta);
        this.txtResult.setText(result);
    }

    protected void handleLoadTableMetaFile() {
        this.chooser.showOpenDialog(this);
        File file = this.chooser.getSelectedFile();
        if (file != null) {
            try {
                this.selectAll(false);
                this.cachePath(file.getAbsolutePath());
                String text = JKIOUtil.readFile(file.getAbsolutePath());
                this.txtResult.setText(text);
                this.parseText(this.txtResult.getText());
                this.mdlTables.fireTableDataChanged();
            }
            catch (Exception e) {
                JKExceptionUtil.handle(e);
            }
        }
    }

    protected void handleSave() {
        this.chooser.showOpenDialog(this);
        File file = this.chooser.getSelectedFile();
        if (file != null) {
            JKIOUtil.writeDataToFile(this.txtResult.getText().getBytes(), file);
        }
    }

    protected void handleShowLables() {
        TableMetaXMLGenerator generator = new TableMetaXMLGenerator();
        ArrayList<TableMeta> selectedTablesMeta = this.getSelectedTablesMeta();
        StringBuffer buf = new StringBuffer();
        for (TableMeta tableMeta : selectedTablesMeta) {
            buf.append(tableMeta.getTableId());
            buf.append("=\n");
            Vector<FieldMeta> fieldList = tableMeta.getFieldList();
            for (FieldMeta fieldMeta : fieldList) {
                buf.append(fieldMeta.getName());
                buf.append("=\n");
            }
        }
        this.txtResult.setText(buf.toString());
    }

    protected void handleShowTableMetaPanel(int selectedRow) {
        TableMeta meta = this.tablesHash.get(this.getTableName(selectedRow));
        TableMetaPanel pnl = new TableMetaPanel(meta, this.tablesHash);
        SwingUtility.showPanelInDialog(pnl, meta.getTableName());
    }

    private void init() {
        this.initTable();
        this.setDefaultCloseOperation(3);
        this.pnlDatabase.setPreferredSize(new Dimension(10, 120));
        this.getContentPane().add((Component)this.pnlDatabase, "North");
        this.northContainer.setBorder(SwingUtility.createTitledBorder("Database Config."));
        this.northContainer.setPreferredSize(new Dimension(700, 100));
        this.pnlDatabase.add(this.northContainer);
        this.northContainer.add(this.lblDriver);
        this.northContainer.add(this.txtDriver);
        this.northContainer.add(this.btnSelectDriver);
        this.northContainer.add(this.btnResetDb);
        this.northContainer.add(this.lblUrl);
        this.northContainer.add(this.txtUrl);
        this.northContainer.add(this.lblUser);
        this.northContainer.add(this.txtUser);
        this.northContainer.add(this.lblPassword);
        this.northContainer.add(this.txtPassword);
        this.northContainer.add(this.btnPing);
        this.northContainer.add(this.btnConnect);
        this.txtPassword.setColumns(10);
        this.txtUser.setColumns(10);
        this.txtUrl.setColumns(25);
        this.txtDriver.setColumns(25);
        this.btnConnect.setShowProgress(true);
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handleConnect();
            }
        });
        this.btnPing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handlePing();
            }
        });
        this.btnResetDb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handleResetDb();
            }
        });
        this.btnSelectDriver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handleSelectDriver();
            }
        });
        JKPanel pnl = new JKPanel(new BorderLayout());
        pnl.setPreferredSize(new Dimension(400, 500));
        JScrollPane pane = new JScrollPane(this.tblTables);
        pane.setBorder(BorderFactory.createTitledBorder("Database Tables"));
        JKPanel<?> pnlButtons = this.getButtonsPanel();
        JKPanel pnl2 = new JKPanel();
        pnl2.add(pnlButtons);
        pnl.add((Component)new JKLabledComponent("Database ", (BindingComponent)this.cmbCatalogs), "North");
        pnl.add((Component)pane, "Center");
        pnl.add(pnl2, "East");
        this.getContentPane().add(pnl, "West");
        JScrollPane txtPane = new JScrollPane(this.txtResult, 22, 32);
        txtPane.setBorder(BorderFactory.createTitledBorder("Result table-meta.xml"));
        this.getContentPane().add((Component)txtPane, "Center");
        this.cmbCatalogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handleDatabaseChanged();
            }
        });
        this.btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handleGenerate();
            }
        });
        this.btnShowLables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handleShowLables();
            }
        });
        this.btnParse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handleParse();
            }
        });
        this.tblTables.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DataBaseAnalyzerFrame.this.handleShowTableMetaPanel(DataBaseAnalyzerFrame.this.tblTables.getSelectedRow());
                }
            }
        });
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handleLoadTableMetaFile();
            }
        });
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.selectAll(true);
            }
        });
        this.btnDeSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.selectAll(false);
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataBaseAnalyzerFrame.this.handleSave();
            }
        });
        this.txtResult.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 70 && e.isControlDown()) {
                    DataBaseAnalyzerFrame.this.handleFind();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.tblTables.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    DataBaseAnalyzerFrame.this.handleShowTableMetaPanel(DataBaseAnalyzerFrame.this.tblTables.getSelectedRow());
                }
            }
        });
        this.btnCompare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DataBaseAnalyzerFrame.this.handleCompare();
                }
                catch (JKDataAccessException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleConnect() {
        this.inProgress = true;
        try {
            this.dataSource = JKDataSourceFactory.createInstance(this.txtDriver.getText(), this.txtUrl.getText(), this.txtUser.getText(), this.txtPassword.getText());
            JKDataSourceFactory.setDefaultDataSource(this.dataSource);
            this.analyzer = DynamicDaoFactory.getDatabaseAnalayzer();
            List<String> catalogs = this.analyzer.getDatabasesName();
            this.cmbCatalogs.removeAllItems();
            for (int i = 0; i < catalogs.size(); ++i) {
                this.cmbCatalogs.addItem(new String(catalogs.get(i)));
            }
            this.cmbCatalogs.setSelectedItem(this.analyzer.getDefaultCatalog());
        }
        finally {
            this.inProgress = false;
            this.handleDatabaseChanged();
        }
    }

    protected void handlePing() {
        JdbcUtil.ping(this.txtDriver.getText(), this.txtUrl.getText(), this.txtUser.getText(), this.txtPassword.getText());
        SwingUtility.showSuccessDialog("Connected Successfully");
    }

    protected void handleResetDb() {
        this.populateDatabaseConfigPanel();
    }

    protected void handleSelectDriver() {
        final JKTable table = JKComponentFactory.createMapTable(JdbcUtil.getJdbcDrivers(), "Driver", "Url");
        table.addRecordSelectionListener(new RecordSelectionListener(){

            @Override
            public void recordSelected(int rowId) {
                DataBaseAnalyzerFrame.this.txtDriver.setText(table.getValueAtAsString(rowId, 0));
                DataBaseAnalyzerFrame.this.txtUrl.setText(table.getValueAtAsString(rowId, 1));
                SwingUtility.closePanelDialog(table);
            }
        });
        SwingUtility.showTableInDialog(table, "JDBC-Drivers");
    }

    private void initTable() {
        JKTableColumn col1 = new JKTableColumn();
        col1.setColumnClass(Boolean.class);
        col1.setName("");
        JKTableColumn col2 = new JKTableColumn();
        col2.setColumnClass(String.class);
        col2.setName("Table Name");
        this.mdlTables.addJKTableColumn(col1);
        this.mdlTables.addJKTableColumn(col2);
        this.tblTables.setEditable(0, true);
        this.tblTables.setColunmEditor(0, new JKCheckBox());
        this.tblTables.setColumnWidth(0, 30);
        this.tblTables.setColumnWidth(1, 200);
    }

    private JKPanel<?> getButtonsPanel() {
        JKPanel pnlButtons = new JKPanel();
        pnlButtons.setLayout(new GridLayout(10, 1, 5, 10));
        pnlButtons.add(this.btnDeSelectAll);
        pnlButtons.add(this.btnSelectAll);
        pnlButtons.add(this.btnGenerate);
        pnlButtons.add(this.btnParse);
        pnlButtons.add(this.btnLoad);
        pnlButtons.add(this.btnSave);
        pnlButtons.add(this.btnCompare);
        pnlButtons.add(this.btnShowLables);
        return pnlButtons;
    }

    void loadPath() {
        String path = JKIOUtil.readFile("oldpath.txt");
        if (path != null) {
            this.chooser.setCurrentDirectory(new File(path));
        }
    }

    private void parseText(String text) throws JKXmlException, FileNotFoundException {
        this.getMetaFactory().getTables().clear();
        this.getMetaFactory().loadMetaFiles(new ByteArrayInputStream(text.getBytes()));
        List<TableMeta> list = this.getMetaFactory().getTablesAsList();
        for (int i = 0; i < list.size(); ++i) {
            TableMeta meta = list.get(i);
            TableMeta old = this.tablesHash.get(meta.getTableName());
            if (old == null) continue;
            this.tablesHash.put(meta.getTableName(), meta);
            int rowNum = this.getTableMetaRowIndex(meta.getTableName());
            this.setChecked(rowNum, true);
        }
        this.mdlTables.fireTableDataChanged();
    }

    private void populateDatabaseConfigPanel() {
        JKDataSource dataSource = JKDataSourceFactory.getDefaultDataSource();
        this.txtDriver.setText(dataSource.getDriverName());
        this.txtUrl.setText(dataSource.getDatabaseUrl());
        this.txtUser.setText(dataSource.getUsername());
        this.txtPassword.setText(dataSource.getPassword());
    }

    private void selectAll(boolean checked) {
        for (int i = 0; i < this.mdlTables.getRowCount(); ++i) {
            this.setChecked(i, checked);
        }
        this.mdlTables.fireTableDataChanged();
    }

    void setChecked(int rowNum, boolean checked) {
        this.tblTables.setValueAt(checked, rowNum, 0);
    }

    private void handleParse() {
        try {
            this.parseText(this.txtResult.getText());
        }
        catch (JKXmlException | FileNotFoundException e) {
            JKExceptionUtil.handle(e);
        }
    }

    private void handleFind() {
        int index;
        String input = SwingUtility.showInputDialog("Enter text to find");
        if (input != null && (index = this.txtResult.getText().substring(this.txtResult.getCaretPosition()).indexOf(input)) != -1) {
            this.txtResult.setCaretPosition(index);
        }
    }
}

