/*
 * Decompiled with CFR 0.152.
 */
package com.jk.db.analayzer.gui;

import com.jk.desktop.swing.BindingComponent;
import com.jk.desktop.swing.SwingUtility;
import com.jk.desktop.swing.comp.JKButton;
import com.jk.desktop.swing.comp.JKComboBox;
import com.jk.desktop.swing.comp.JKTextField;
import com.jk.desktop.swing.comp.panels.JKLabledComponent;
import com.jk.desktop.swing.comp.panels.JKPanel;
import com.jk.desktop.swing.text.documents.FloatDocument;
import com.jk.metadata.db.constraints.Constraint;
import com.jk.metadata.db.constraints.DataRangeConstraint;
import com.jk.metadata.db.constraints.DuplicateDataConstraint;
import com.jk.metadata.db.constraints.IdenticalFieldsContraint;
import com.jk.metadata.db.constraints.LessThanContsraint;
import com.jk.metadata.db.meta.TableMeta;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class ConstraintPanel
extends JKPanel<Object> {
    private static final long serialVersionUID = 1L;
    private TableMeta tableMeta;
    private Constraint constraint;
    JKTextField txtName = new JKTextField(20);
    JKComboBox cmbType = new JKComboBox();
    JList<String> lstFields = new JList();
    private DefaultListModel<String> fieldsModel;
    JKButton btnSave = new JKButton("Save");
    JKButton btnAdd = new JKButton("Add");
    JKButton btnDelete = new JKButton("Delete");
    private final JKTextField txtValueFrom = new JKTextField(new FloatDocument(5), 20);
    private final JKTextField txtValueTo = new JKTextField(new FloatDocument(5), 20);

    public ConstraintPanel(TableMeta tableMeta) {
        this.init(tableMeta, null);
        this.btnSave.setVisible(false);
        this.btnDelete.setVisible(false);
    }

    public ConstraintPanel(TableMeta tableMeta, Constraint constraint) {
        this.init(tableMeta, constraint);
        this.cmbType.setEnabled(false);
        this.btnAdd.setVisible(false);
        this.modelToView();
    }

    protected void closePanel() {
        Container cont = this.getParent();
        cont.remove(this);
        cont.validate();
        cont.repaint();
    }

    protected void handleAdd() {
        CONSTRAINT_TYPES constType = (CONSTRAINT_TYPES)((Object)this.cmbType.getSelectedItem());
        try {
            Constraint instance;
            if (constType.equals((Object)CONSTRAINT_TYPES.NO_DUPLICATE)) {
                instance = (Constraint)DuplicateDataConstraint.class.newInstance();
            } else if (constType.equals((Object)CONSTRAINT_TYPES.DATA_RANGE)) {
                DataRangeConstraint cons = (DataRangeConstraint)DataRangeConstraint.class.newInstance();
                cons.setValueFrom(Float.parseFloat(this.txtValueFrom.getText()));
                cons.setValueTo(Float.parseFloat(this.txtValueTo.getText()));
                instance = cons;
            } else if (constType.equals((Object)CONSTRAINT_TYPES.LESS_THAN)) {
                LessThanContsraint cons = (LessThanContsraint)LessThanContsraint.class.newInstance();
                instance = cons;
            } else if (constType.equals((Object)CONSTRAINT_TYPES.NO_IDENTICAL_FIELDS)) {
                IdenticalFieldsContraint cons = (IdenticalFieldsContraint)IdenticalFieldsContraint.class.newInstance();
                instance = cons;
            } else {
                instance = (Constraint)Constraint.class.newInstance();
            }
            instance.setTableMeta(this.tableMeta);
            this.tableMeta.getConstraints().add(instance);
            this.constraint = instance;
            this.viewToModel();
            SwingUtility.closePanelDialog(this);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        JKPanel pnl = new JKPanel(new GridLayout(1, 2));
        JKPanel pnlInfo = new JKPanel();
        pnlInfo.setLayout(new BoxLayout(pnlInfo, 1));
        pnlInfo.setBorder(BorderFactory.createTitledBorder("Constraint info"));
        pnlInfo.add(new JKLabledComponent("Name ", (BindingComponent)this.txtName));
        pnlInfo.add(new JKLabledComponent("Type ", (BindingComponent)this.cmbType));
        pnlInfo.add(new JKLabledComponent("Value from", (BindingComponent)this.txtValueFrom));
        pnlInfo.add(new JKLabledComponent("Value To", (BindingComponent)this.txtValueTo));
        JKPanel pnlFields = new JKPanel(new BorderLayout());
        pnlFields.setBorder(BorderFactory.createTitledBorder("Fields list"));
        pnlFields.add((Component)new JScrollPane(this.lstFields), "Center");
        JKPanel pnlButtons = new JKPanel();
        pnlButtons.add(this.btnAdd);
        pnlButtons.add(this.btnSave);
        pnlButtons.add(this.btnDelete);
        pnlFields.add(pnlButtons, "South");
        pnl.add(pnlInfo);
        pnl.add(pnlFields);
        this.add(pnl);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintPanel.this.viewToModel();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintPanel.this.handleAdd();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintPanel.this.tableMeta.getConstraints().remove(ConstraintPanel.this.constraint);
                ConstraintPanel.this.closePanel();
            }
        });
    }

    private void init(TableMeta tableMeta, Constraint constraint) {
        this.tableMeta = tableMeta;
        this.constraint = constraint;
        this.cmbType.addItem(CONSTRAINT_TYPES.NO_DUPLICATE);
        this.cmbType.addItem(CONSTRAINT_TYPES.NO_IDENTICAL_FIELDS);
        this.cmbType.addItem(CONSTRAINT_TYPES.DATA_RANGE);
        this.cmbType.addItem(CONSTRAINT_TYPES.LESS_THAN);
        this.fieldsModel = new DefaultListModel();
        for (int i = 0; i < tableMeta.getFieldList().size(); ++i) {
            this.fieldsModel.addElement(tableMeta.getFieldList().get(i).getName());
        }
        this.lstFields.setModel(this.fieldsModel);
        this.init();
    }

    private void modelToView() {
        if (this.constraint instanceof DuplicateDataConstraint) {
            this.cmbType.setSelectedItem((Object)CONSTRAINT_TYPES.NO_DUPLICATE);
        } else if (this.constraint instanceof IdenticalFieldsContraint) {
            this.cmbType.setSelectedItem((Object)CONSTRAINT_TYPES.NO_IDENTICAL_FIELDS);
        } else if (this.constraint instanceof LessThanContsraint) {
            this.cmbType.setSelectedItem((Object)CONSTRAINT_TYPES.LESS_THAN);
        } else if (this.constraint instanceof DataRangeConstraint) {
            this.cmbType.setSelectedItem((Object)CONSTRAINT_TYPES.DATA_RANGE);
            this.txtValueFrom.setText(((DataRangeConstraint)this.constraint).getValueFrom() + "");
            this.txtValueTo.setText(((DataRangeConstraint)this.constraint).getValueTo() + "");
        }
        this.txtName.setText(this.constraint.getName());
        for (int i = 0; i < this.constraint.getFields().size(); ++i) {
            int index = this.fieldsModel.indexOf(this.constraint.getFields().get(i).getName());
            this.lstFields.addSelectionInterval(index, index);
        }
    }

    void viewToModel() {
        int[] selecredFields;
        this.constraint.getFields().clear();
        for (int selecredField : selecredFields = this.lstFields.getSelectedIndices()) {
            this.constraint.addField(this.tableMeta.getField(this.fieldsModel.get(selecredField)));
        }
        this.constraint.setName(this.txtName.getText());
        if (this.constraint instanceof DataRangeConstraint) {
            ((DataRangeConstraint)this.constraint).setValueFrom(Float.parseFloat(this.txtValueFrom.getText()));
            ((DataRangeConstraint)this.constraint).setValueTo(Float.parseFloat(this.txtValueTo.getText()));
        }
    }

    static enum CONSTRAINT_TYPES {
        NO_DUPLICATE,
        DATA_RANGE,
        NO_IDENTICAL_FIELDS,
        LESS_THAN;


        public String toString() {
            if (this == NO_DUPLICATE) {
                return "No Duplicate";
            }
            if (this == DATA_RANGE) {
                return "Data Range";
            }
            if (this == NO_IDENTICAL_FIELDS) {
                return "No Identical Fields";
            }
            if (this == LESS_THAN) {
                return "Less Than";
            }
            return "";
        }
    }
}

