/*
 * Decompiled with CFR 0.152.
 */
package com.jk.context;

import com.jk.context.JKContext;
import com.jk.context.impl.JKDesktopContext;
import com.jk.context.impl.JKJsfContext;
import com.jk.context.impl.JKMobileContext;
import com.jk.context.impl.JKServletContext;
import com.jk.thread.JKThreadLocal;

public class JKContextFactory {
    private static JKContextFactory factoryImpl;

    protected static JKContextFactory getInstance() {
        if (factoryImpl == null) {
            factoryImpl = new JKContextFactory();
        }
        return factoryImpl;
    }

    public static void setInstance(JKContextFactory instance) {
        factoryImpl = instance;
    }

    public JKContext createDesktopContext() {
        return new JKDesktopContext();
    }

    public JKMobileContext createMobileContext() {
        return new JKMobileContext();
    }

    public JKJsfContext createJsfContext() {
        return new JKJsfContext();
    }

    public JKServletContext createJkServletContext() {
        return new JKServletContext();
    }

    public static JKContext getCurrentContext() {
        JKContext context = (JKContext)JKThreadLocal.getValue("jk.context");
        if (context == null) {
            context = JKContextFactory.getInstance().createDesktopContext();
            JKThreadLocal.setValue("jk.context", context);
        }
        return context;
    }

    public static void setCurrentContext(JKContext context) {
        JKThreadLocal.setValue("jk.context", context);
    }
}

