/*
 * Decompiled with CFR 0.152.
 */
package com.jk.context;

import com.jk.context.JKContext;
import com.jk.resources.JKResourceLoader;
import com.jk.resources.JKResourceLoaderFactory;
import com.jk.thread.JKThreadLocal;
import java.util.HashMap;
import java.util.Map;

public abstract class JKAbstractContext
implements JKContext {
    @Override
    public HashMap<String, Object> getApplicationMap() {
        return (HashMap)JKThreadLocal.getValue("jk.applicationMap");
    }

    @Override
    public Object getAttribute(String attribute) {
        return JKThreadLocal.getValue(attribute);
    }

    @Override
    public String getMachineName() {
        return (String)JKThreadLocal.getValue("jk.machineName");
    }

    @Override
    public String getRemoteIP() {
        return (String)JKThreadLocal.getValue("jk.ipAddress");
    }

    @Override
    public int getRemotPort() {
        return (Integer)JKThreadLocal.getValue("jk.portNumber");
    }

    @Override
    public HashMap<String, Object> getRequestMap() {
        return (HashMap)JKThreadLocal.getValue("jk.requestMap");
    }

    @Override
    public String getSessionID() {
        return (String)JKThreadLocal.getValue("jk.httpSessionId");
    }

    @Override
    public HashMap<String, Object> getSessionMap() {
        return (HashMap)JKThreadLocal.getValue("jk.sessionMap");
    }

    @Override
    public Object getUser() {
        return JKThreadLocal.getValue("jk.user");
    }

    @Override
    public void setAttribute(String key, Object value) {
        JKThreadLocal.setValue(key, value);
    }

    public void setApplicationMap(Map<String, Object> applicationMap) {
        JKThreadLocal.setValue("jk.applicationMap", applicationMap);
    }

    public void setMachineName(String machineName) {
        JKThreadLocal.setValue("jk.machineName", machineName);
    }

    public void setRemoteIP(String remoteIP) {
        JKThreadLocal.setValue("jk.ipAddress", remoteIP);
    }

    public void setRemotPort(int remotPort) {
        JKThreadLocal.setValue("jk.portNumber", remotPort);
    }

    public void setRequestMap(Map<String, Object> requestMap) {
        JKThreadLocal.setValue("jk.requestMap", requestMap);
    }

    public void setSessionID(String sessionID) {
        JKThreadLocal.setValue("jk.httpSessionId", sessionID);
    }

    public void setSessionMap(Map<String, Object> sessionMap) {
        JKThreadLocal.setValue("jk.sessionMap", sessionMap);
    }

    public void setUser(Object user) {
        JKThreadLocal.setValue("jk.user", user);
    }

    @Override
    public JKResourceLoader getResourceLoader() {
        return JKResourceLoaderFactory.getResourceLoader();
    }

    @Override
    public String getConfigPath() {
        return JKThreadLocal.getValue("jk.config.path", "").toString();
    }

    public void setConfigPath(String configPath) {
        JKThreadLocal.setValue("jk.config.path", configPath);
    }
}

