/*
 * Decompiled with CFR 0.152.
 */
package com.jk.cache.simple;

import com.jk.cache.JKCacheManager;
import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import java.util.HashMap;
import java.util.Map;

public abstract class JKAbstractCacheManager
implements JKCacheManager {
    private static final Class<Object> NULLABLE_MAP_CLASS = Object.class;
    protected JKLogger logger = JKLoggerFactory.getLogger(this.getClass());
    private final Map<Class<?>, Map<Object, Object>> cachablesMaps = new HashMap();
    private boolean allowNullable = true;

    @Override
    public void cache(Object key, Object object) {
        this.logger.debug("@cache ");
        if (object == null) {
            if (!this.isAllowNullable()) {
                return;
            }
            this.logger.debug("logging key :", key, " with null");
            this.getCachableMap(NULLABLE_MAP_CLASS).put(key, null);
        } else {
            this.cache(key, object, object.getClass());
        }
    }

    @Override
    public <T> void cache(Object key, Object object, Class<T> clas) {
        this.logger.debug("@cache v2 ");
        if (object == null && !this.isAllowNullable()) {
            return;
        }
        this.logger.debug("logging key :", key, " with object : ", object, " with Class : ", clas);
        this.getCachableMap(clas).put(key, object);
    }

    @Override
    public void clear(Class<?> clas) {
        this.logger.debug("@clear:".concat(clas.getName()));
        this.getCachableMap(clas).clear();
    }

    @Override
    public <T> T get(Object key, Class<T> clas) {
        this.logger.debug("@get :", key, " with class : ", clas.getName());
        Object Object2 = this.getCachableMap(clas).get(key);
        this.logger.debug("Cached object : ", Object2);
        return (T)Object2;
    }

    public Map<Object, Object> getCachableMap(Class<?> clas) {
        this.logger.debug("@getCachableMap for class ", clas.getName());
        Map<Object, Object> map = this.cachablesMaps.get(clas);
        if (map == null) {
            this.logger.debug("Cachable map not found , create one");
            map = new HashMap<Object, Object>();
            this.cachablesMaps.put(clas, map);
        }
        return map;
    }

    public boolean isAllowNullable() {
        return this.allowNullable;
    }

    @Override
    public boolean isAvailable(Object key, Class<?> clas) {
        this.logger.debug("@isAvailable :".concat(key.toString()).concat(" for class : ".concat(clas.toString())));
        Object Object2 = this.getCachableMap(clas).get(key);
        if (Object2 == null) {
            this.logger.debug("try to find it on the nullable cache");
            this.logger.debug(this.getCachableMap(NULLABLE_MAP_CLASS).keySet().toString());
            return this.getCachableMap(NULLABLE_MAP_CLASS).containsKey(key);
        }
        this.logger.debug("key ".concat(key.toString()).concat(Object2 != null ? " is available in the cache" : "is not svailable"));
        return Object2 != null;
    }

    @Override
    public void remove(Object key, Class<?> clas) {
        this.logger.debug("@remove :".concat(key.toString()).concat(" with class : ".concat(clas.getName())));
        this.getCachableMap(clas).remove(key);
    }

    public void setAllowNullable(boolean allowNullable) {
        this.allowNullable = allowNullable;
    }
}

