/*
 * Decompiled with CFR 0.152.
 */
package com.jk.annotations;

import com.jk.annotations.AnnotationHandler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.AnnotationTypeFilter;

public class AnnotationDetector {
    public static void scan(Class<? extends Annotation> clas, String[] basePackage, AnnotationHandler handler) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setResourceLoader(new PathMatchingResourcePatternResolver(Thread.currentThread().getContextClassLoader()));
        scanner.addIncludeFilter(new AnnotationTypeFilter(clas));
        for (String pck : basePackage) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pck)) {
                handler.handleAnnotationFound(bd.getBeanClassName());
            }
        }
    }

    public static List<String> scanAsList(Class<? extends Annotation> clas, String ... basePackage) {
        final ArrayList<String> classes = new ArrayList<String>();
        AnnotationDetector.scan(clas, basePackage, new AnnotationHandler(){

            @Override
            public void handleAnnotationFound(String className) {
                classes.add(className);
            }
        });
        return classes;
    }
}

