/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util.beans;

import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanUtil;
import java.lang.reflect.Method;
import java.util.HashMap;

public class BeanDescriptionFactory {
    public static final BeanDescriptionFactory INSTANCE = new BeanDescriptionFactory();
    private BeanUtil beanUtil = BeanUtil.INSTANCE;

    public BeanDescription create(Class<?> clazz) {
        Method[] methods;
        HashMap<String, Method> propertyNameToGetter = new HashMap<String, Method>();
        HashMap<String, Method> propertyNameToSetter = new HashMap<String, Method>();
        HashMap<String, Method> propertyNameToAdder = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            Method oldAdder;
            String message;
            String propertyName;
            if (this.beanUtil.isGetter(method)) {
                propertyName = this.beanUtil.getPropertyName(method);
                Method oldGetter = propertyNameToGetter.put(propertyName, method);
                if (oldGetter == null) continue;
                if (oldGetter.getName().startsWith("is")) {
                    propertyNameToGetter.put(propertyName, oldGetter);
                }
                message = String.format("Warning: Class '%s' contains multiple getters for the same property '%s'.", clazz.getCanonicalName(), propertyName);
                System.err.println(message);
                continue;
            }
            if (this.beanUtil.isSetter(method)) {
                propertyName = this.beanUtil.getPropertyName(method);
                Method oldSetter = propertyNameToSetter.put(propertyName, method);
                if (oldSetter == null) continue;
                message = String.format("Warning: Class '%s' contains multiple setters for the same property '%s'.", clazz.getCanonicalName(), propertyName);
                System.err.println(message);
                continue;
            }
            if (!this.beanUtil.isAdder(method) || (oldAdder = propertyNameToAdder.put(propertyName = this.beanUtil.getPropertyName(method), method)) == null) continue;
            message = String.format("Warning: Class '%s' contains multiple adders for the same property '%s'.", clazz.getCanonicalName(), propertyName);
            System.err.println(message);
        }
        return new BeanDescription(clazz, propertyNameToGetter, propertyNameToSetter, propertyNameToAdder);
    }
}

